<?php

namespace App\Models;

use CodeIgniter\Model;

class Ip2locationLiteDb11Model extends Model
{
    protected $table            = 'ip2location_lite_db11';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $allowedFields    = [
        'ip_from',
        'ip_to',
        'country_code',
        'country_name',
        'region',
        'city',
        'latitude',
        'longitude',
        'zip_code',
        'time_zone',
    ];

    /**
     * Find row by IPv4 address (ip_from/ip_to are decimal; use INET_ATON for lookup).
     */
    public function findByIp(string $ip): ?object
    {
        $fullTable = $this->db->DBPrefix . $this->table;
        $sql       = 'SELECT * FROM ' . $this->db->escapeIdentifiers($fullTable)
            . ' WHERE INET_ATON(?) BETWEEN ip_from AND ip_to LIMIT 1';

        $result = $this->db->query($sql, [$ip]);
        $row    = $result->getRow();

        return $row ?: null;
    }
}
