<?php

namespace App\Models;

use CodeIgniter\Model;

class DbipCityIpv4Model extends Model
{
    protected $table            = 'dbip_city_ipv4';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $allowedFields    = [
        'start_ip',
        'end_ip',
        'country_code',
        'region',
        'city',
        'latitude',
        'longitude',
    ];

    /**
     * Find row by IPv4 address (lookup by IP range).
     */
    public function findByIp(string $ip): ?object
    {
        $fullTable = $this->db->DBPrefix . $this->table;
        $sql       = 'SELECT * FROM ' . $this->db->escapeIdentifiers($fullTable)
            . ' WHERE INET_ATON(?) BETWEEN INET_ATON(start_ip) AND INET_ATON(end_ip) LIMIT 1';

        $result = $this->db->query($sql, [$ip]);
        $row    = $result->getRow();

        return $row ?: null;
    }
}
