<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class RenameGeolocationColumnsToMatchCsv extends Migration
{
    public function up(): void
    {
        // Check if table exists before trying to rename columns
        if (! $this->db->tableExists('geolocationDatabaseIPv4')) {
            return;
        }

        $this->forge->modifyColumn('geolocationDatabaseIPv4', [
            'ip_start' => [
                'name'       => 'start_ip',
                'type'       => 'VARCHAR',
                'constraint' => 15,
                'null'       => false,
            ],
            'ip_end' => [
                'name'       => 'end_ip',
                'type'       => 'VARCHAR',
                'constraint' => 15,
                'null'       => false,
            ],
            'country_name' => [
                'name'       => 'country',
                'type'       => 'VARCHAR',
                'constraint' => 100,
                'null'       => true,
            ],
            'time_zone' => [
                'name'       => 'timezone',
                'type'       => 'VARCHAR',
                'constraint' => 50,
                'null'       => true,
            ],
            'accuracy_radius' => [
                'name'       => 'accuracy',
                'type'       => 'INT',
                'constraint' => 11,
                'null'       => true,
            ],
        ]);
    }

    public function down(): void
    {
        // Check if table exists before trying to rename columns
        if (! $this->db->tableExists('geolocationDatabaseIPv4')) {
            return;
        }

        $this->forge->modifyColumn('geolocationDatabaseIPv4', [
            'start_ip' => [
                'name'       => 'ip_start',
                'type'       => 'VARCHAR',
                'constraint' => 15,
                'null'       => false,
            ],
            'end_ip' => [
                'name'       => 'ip_end',
                'type'       => 'VARCHAR',
                'constraint' => 15,
                'null'       => false,
            ],
            'country' => [
                'name'       => 'country_name',
                'type'       => 'VARCHAR',
                'constraint' => 100,
                'null'       => true,
            ],
            'timezone' => [
                'name'       => 'time_zone',
                'type'       => 'VARCHAR',
                'constraint' => 50,
                'null'       => true,
            ],
            'accuracy' => [
                'name'       => 'accuracy_radius',
                'type'       => 'INT',
                'constraint' => 11,
                'null'       => true,
            ],
        ]);
    }
}
