<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateGeolocationDatabaseIPv4Table extends Migration
{
    public function up(): void
    {
        // Check if table already exists
        if ($this->db->tableExists('geolocationDatabaseIPv4')) {
            return;
        }

        $this->forge->addField([
            'id'             => ['type' => 'INT', 'constraint' => 11, 'unsigned' => true, 'auto_increment' => true],
            'ip_start'       => ['type' => 'VARCHAR', 'constraint' => 15, 'null' => false],
            'ip_end'         => ['type' => 'VARCHAR', 'constraint' => 15, 'null' => false],
            'country_code'   => ['type' => 'CHAR', 'constraint' => 2, 'null' => true],
            'country_name'   => ['type' => 'VARCHAR', 'constraint' => 100, 'null' => true],
            'state'          => ['type' => 'VARCHAR', 'constraint' => 100, 'null' => true],
            'city'           => ['type' => 'VARCHAR', 'constraint' => 100, 'null' => true],
            'zip'            => ['type' => 'DECIMAL', 'constraint' => '5,0', 'null' => true],
            'time_zone'      => ['type' => 'VARCHAR', 'constraint' => 50, 'null' => true],
            'latitude'       => ['type' => 'DECIMAL', 'constraint' => '10,8', 'null' => true],
            'longitude'      => ['type' => 'DECIMAL', 'constraint' => '11,8', 'null' => true],
            'accuracy_radius' => ['type' => 'INT', 'constraint' => 11, 'null' => true],
            'source'         => ['type' => 'VARCHAR', 'constraint' => 50, 'null' => true],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addKey(['ip_start', 'ip_end']);
        $this->forge->createTable('geolocationDatabaseIPv4');
    }

    public function down(): void
    {
        $this->forge->dropTable('geolocationDatabaseIPv4');
    }
}
