<?php

namespace App\Controllers\Api;

use App\Controllers\BaseController;
use App\Models\Ip2locationLiteDb11Model;
use CodeIgniter\HTTP\ResponseInterface;

class Ip2location extends BaseController
{
    /**
     * GET api/ip2location?ip=1.0.0.1
     * Returns IP2Location LITE DB11 data for the given IPv4 address.
     */
    public function index(): ResponseInterface
    {
        $ip = $this->request->getGet('ip');

        if ($ip === null || $ip === '') {
            return $this->response
                ->setJSON([
                    'success' => false,
                    'error'   => 'Missing parameter: ip',
                ])
                ->setStatusCode(400);
        }

        $ip = trim($ip);

        if (! filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) {
            return $this->response
                ->setJSON([
                    'success' => false,
                    'error'   => 'Invalid IPv4 address',
                ])
                ->setStatusCode(400);
        }

        $model = model(Ip2locationLiteDb11Model::class);
        $row  = $model->findByIp($ip);

        if ($row === null) {
            return $this->response
                ->setJSON([
                    'success' => false,
                    'error'   => 'No IP2Location data found for this IP',
                    'ip'      => $ip,
                ])
                ->setStatusCode(404);
        }

        return $this->response->setJSON([
            'success' => true,
            'ip'      => $ip,
            'source'  => 'ip2location_lite_db11',
            'data'    => $row,
        ]);
    }
}
